
'********************************************************************************
'If you should have any comments, suggestions or improvements to these samples, 
'we welcome you to contact us at SampleCode@melissadata.com also please visit our 
'developers bulletin board at forum.melissadata.com.
'********************************************************************************

Public Class mdNameCOMExample

    Private IName As New mdNAMEOBJECTLib.mdName

	Private Sub mdNameCOMExample_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

		' Change the following lines to reflect your installation location
		'   of the mdName API and the license string:
		' The Data Files Directory must contain the following files: mdName.dat and mdName.cfg.
        Const dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data"

        '/********************** LICENSE STRINGS **********************
        '*     To unlock the full functionality of Name Object,       *
        '*     	     Or to obtain a Demo License String               *
        '* please call a sales representative at 1-800-MELISSA ext. 3 *
        '*         (1-800-635-4772 x3) for a license string.          *
        '**************************************************************/
        Const dLICENSE = "DEMO"

        If IName.SetLicenseString(dLICENSE) = mdNAMEOBJECTLib.ProgramStatus.NoError Then
            Call MsgBox("Error setting License to " & dLICENSE & ". Please contact a Melissa " & _
                "Data sales representative at 1-800-800-6245 x3 for a valid license string.", 0, _
                "License Error")
            Close()
        Else
            IName.PathToNameFiles = dFILELOC
            If IName.InitializeDataFiles() <> 0 Then
                Call MsgBox("Error Initializing mdName: " & _
                 IName.GetInitializeErrorString(), 0, _
                 "Initialize Error")
                Close()
            End If

            Build.Text = IName.GetBuildNumber
            DatabaseDate.Text = IName.GetDatabaseDate
            DatabaseExpirationDate.Text = IName.GetDatabaseExpirationDate
            LicenseExpirationDate.Text = IName.GetLicenseExpirationDate

            ' Set a few processing options:
            IName.PrimaryNameHint = mdNAMEOBJECTLib.NameHints.VeryLikelyFull
            IName.FirstNameSpellingCorrection = 1
            IName.SalutationPrefix = "Dear"
            IName.SalutationSuffix = ":"
            IName.SalutationSlug = "Valued Customer"
        End If


	End Sub

	Private Sub mdNameCOMExample_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
		IName = Nothing
	End Sub

	Private Sub Submit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Submit.Click
        Dim ResultsString As String
        Dim OutString As String
        IName.ClearProperties()
		IName.FullName = FullName.Text
		IName.Parse()

        Gender.Text = IName.Gender
        Prefix.Text = IName.Prefix
		FirstName.Text = IName.FirstName
		MiddleName.Text = IName.MiddleName
		LastName.Text = IName.LastName
		Suffix.Text = IName.Suffix
		Gender2.Text = IName.Gender2
		Prefix2.Text = IName.Prefix2
		FirstName2.Text = IName.FirstName2
		MiddleName2.Text = IName.MiddleName2
		LastName2.Text = IName.LastName2
		Suffix2.Text = IName.Suffix2
        Salutation.Text = IName.Salutation

        ResultsString = IName.Results
        ' results are returned as a delimited string, so we parse it here...
        If (InStr(1, ResultsString, "NS01")) Then
            OutString = OutString + "NS01: There were no Errors." + vbCrLf
        End If
        If (InStr(1, ResultsString, "NS03")) Then
            OutString = OutString + "NS03: The spelling of the FirstName field was corrected." + vbCrLf
        End If
        If (InStr(1, ResultsString, "NS04")) Then
            OutString = OutString + "NS04: The spelling of the FirstName2 field was corrected." + vbCrLf
        End If

        If (InStr(1, ResultsString, "NS02")) Then
            OutString = OutString + "NS02: There was an Error." + vbCrLf
        End If
        If (InStr(1, ResultsString, "NE01")) Then
            OutString = OutString + "NE01: Two names were detected but the FullName string was not in a recognized format." + vbCrLf
        End If
        If (InStr(1, ResultsString, "NE02")) Then
            OutString = OutString + "NE02: Multiple first names  could not accurately genderize." + vbCrLf
        End If
        If (InStr(1, ResultsString, "NE03")) Then
            OutString = OutString + "NE03: A vulgarity was detected in the name." + vbCrLf
        End If
        If (InStr(1, ResultsString, "NE04")) Then
            OutString = OutString + "NE04: The name contained words found on the list of nuisance names [such as Mickey Mouse]" + vbCrLf
        End If
        If (InStr(1, ResultsString, "NE05")) Then
            OutString = OutString + "NE05: The name contained words normally found in a company name." + vbCrLf
        End If
        If (InStr(1, ResultsString, "NE06")) Then
            OutString = OutString + "NE06: The named contained a non-alphabetic character." + vbCrLf
        End If
        ResultsCodes.Text = OutString
	End Sub

	
    Private Sub Clear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Clear.Click
        Gender.Text = ""
        Prefix.Text = ""
        FirstName.Text = ""
        MiddleName.Text = ""
        LastName.Text = ""
        Suffix.Text = ""
        Gender2.Text = ""
        Prefix2.Text = ""
        FirstName2.Text = ""
        MiddleName2.Text = ""
        LastName2.Text = ""
        Suffix2.Text = ""
        Salutation.Text = ""
        ResultsCodes.Text = ""
    End Sub
End Class
